package ws.afterglo.audioPod;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.security.auth.login.FailedLoginException;

/**
 * @author muti
 * modified by philippe
 *
 */
public class Scrobbler {
	private final int NB_SONGS_POST=50;
    private String	username;
    private String	password;
    private String	challenge;
    private String	submithost;
    private Integer	submitport;
    private String	submiturl;
    private Logger	logger;
    private UI ui;
    
    
    public Scrobbler(String username, String password, UI ui) {
        this.username = username;
        this.password = password;
        this.logger = Logger.getLogger(this.getClass().getPackage().getName());
        this.ui=ui;
    }
    
    public void handshake() throws UnsupportedEncodingException, MalformedURLException,
                                   IOException, FailedLoginException
    {
        if(AudioPod.recentplayed.size() == 0) {
            throw new RuntimeException("No tracks to submit");
        }
        
        this.logger.log(Level.INFO, "Beginning Handshake");
        
        String args = "?hs=true&p=1.1&c=agi&v=0.7&u=" + URLEncoder.encode(this.username, "UTF-8");
        URL url = new URL("http://post.audioscrobbler.com/" + args);
        this.logger.log(Level.FINE, "Handshaking to URL: " + url.toString());
        HttpURLConnection c = (HttpURLConnection)url.openConnection();
        
        c.setDoInput(true);
        c.setRequestMethod("GET");
        c.setUseCaches(false);
        c.setRequestProperty("Connection", "close");
        c.connect();
        
        if(c.getResponseCode() != 200) {
            throw new RuntimeException("Invalid HTTP return code");
        }
        
        BufferedReader breader = new BufferedReader(
                new InputStreamReader(
                        c.getInputStream()
                )
        );
        
        String content = null;
        String buffer = null;
        while ((buffer = breader.readLine()) != null) {
            if(content != null) {
                content += buffer + "\n";
            } else {
                content = buffer + "\n";
            }
        }
        this.logger.log(Level.FINE, "Received from server:\n" + content);
        
        if(content.length() == 0) {
            throw new RuntimeException("Invalid response received from AudioScrobbler");
        }
        
        String lines[] = content.split("\n");
        if(lines[0].length() >= 6 && lines[0].substring(0, 6).equals("FAILED")) {
            throw new RuntimeException(lines[0].substring(7));
        }
        if(lines[0].length() >= 7 && lines[0].substring(0, 7).equals("BADUSER")) {
            throw new FailedLoginException("Invalid Username");
        }
        if(lines[0].length() >= 6 && lines[0].substring(0, 6).equals("UPDATE")) {
            throw new RuntimeException("Update your client:" + lines[0].substring(7));
        }
        
        Pattern p = Pattern.compile("http://(.*):(\\d+)(.*)");
        Matcher m = p.matcher(lines[2]);
        if(m.matches()) {
            this.submithost = m.group(1);
            this.submitport = new Integer(m.group(2));
            this.submiturl  = m.group(3);
            //this.logger.log(Level.FINE, "Set submithost to: " + this.submithost);
            //this.logger.log(Level.FINE, "Set submitport to: " + this.submitport);
            //this.logger.log(Level.FINE, "Set submiturl to: " + this.submiturl);
        } else {
            throw new RuntimeException("Invalid POST URL returned, unable to continue");
        }
        this.challenge = lines[1];
        
        this.logger.log(Level.INFO, "Handshake completed");
    }
    
    public void submittracks() throws UnsupportedEncodingException, NoSuchAlgorithmException,
                                      MalformedURLException, IOException, FailedLoginException
    {
        //this.logger.log(Level.INFO, "Submitting tracks...");
        if(AudioPod.toSubmit.size() == 0) {
            throw new RuntimeException("No tracks to submit");
        }
        
        MessageDigest md = MessageDigest.getInstance("MD5");
        String md5pass = this.hexencode(md.digest(this.password.getBytes())) + this.challenge;
        String md5chal = this.hexencode(md.digest(md5pass.getBytes()));
        
        //modified
        //TODO: correct tracknum
        URL url = new URL("http://" + this.submithost + ":" + this.submitport + this.submiturl);
        this.logger.log(Level.FINE, "Submitting tracks to URL: " + url.toString());
        HttpURLConnection c;
        int tracknum = 0;
        int totaltracks=0;
        int all=AudioPod.toSubmit.size();
        int nbParts=(all-AudioPod.iPodShortCount)/NB_SONGS_POST+1;
        int totalTries=0;
        for(int k=0;k<nbParts;k++){
        	if(totalTries>=3)
        		break;
        	c = (HttpURLConnection)url.openConnection();
            c.setRequestMethod("POST");
            c.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            c.setRequestProperty("Connection", "close");
            c.setDoInput(true);
            c.setDoOutput(true);
            c.setUseCaches(false);
	        String querystring = "u=" + URLEncoder.encode(this.username,"UTF-8") + "&" +
	                             "s=" + URLEncoder.encode(md5chal,"UTF-8") + "&";
	        tracknum = 0;
	        int nbretry=0;
	        int i;
	        for(i = (0+50*k); i < NB_SONGS_POST*k+NB_SONGS_POST; i++) {
	        	if(AudioPod.toSubmit.size()<=i || totalTries>=3)
	        		break;
	            TrackItem track = (TrackItem)AudioPod.toSubmit.get(i);
	            
	            if(track.getLength() < 30)
	                continue;
	            
	            String artistutf8 = new String( track.getArtist().getBytes("UTF-8"), "UTF-8");
	            String trackutf8  = new String( track.getTrack().getBytes("UTF-8"), "UTF-8");
	            String albumutf8 = new String( track.getAlbum().getBytes("UTF-8"), "UTF-8");
	            String mbidutf8 = new String( track.getMBID().getBytes("UTF-8"), "UTF-8");
	            Date date = new Date(track.getLastplayed() * 1000);
	            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	            format.setTimeZone(TimeZone.getTimeZone("GMT:00"));
	            String datestring = format.format(date);
	            
	            querystring += "a[" + tracknum + "]=" + URLEncoder.encode(artistutf8, "UTF-8") + "&";
	            querystring += "t[" + tracknum + "]=" + URLEncoder.encode(trackutf8, "UTF-8") + "&";
	            querystring += "b[" + tracknum + "]=" + URLEncoder.encode(albumutf8, "UTF-8") + "&";
	            querystring += "m[" + tracknum + "]=" + URLEncoder.encode(mbidutf8, "UTF-8") + "&";
	            querystring += "l[" + tracknum + "]=" + URLEncoder.encode(new Long(track.getLength()).toString(), "UTF-8") + "&";
	            querystring += "i[" + tracknum + "]=" + URLEncoder.encode(datestring, "UTF-8") + "&";
	            
	            tracknum++;
	        }
	        //querystring = querystring.substring(0, querystring.length() - 1); //trim last &
	        c.setRequestProperty("Content-Length", new Integer(querystring.length()).toString());

	        //this.logger.log(Level.FINE, "Tracks "+(1+50*k)+" to "+(i+50*k)+" (out of "+AudioPod.toSubmit.size()+"):");
	        if(submitSongs(c, querystring)){
	        	totalTries=0;
	        	totaltracks+=tracknum;
	        }else{
	        	totalTries++;
	        	if(totalTries<=3){
	        		this.logger.log(Level.INFO, "Failed to submit tracks"+(1+50*k)+" to "+(i+50*k)+". "+(3-nbretry)+" retry left.");
			        totalTries++;
	        		k--;
	        	}else{
	        		this.logger.log(Level.WARNING, "The submission server is probably down. Please try again later.");
	        	}
	        }
    	}
    
        this.logger.log(Level.INFO, (AudioPod.toSubmit.size()-AudioPod.iPodShortCount)+" tracks submitted");
        if(!AudioPod.delPlaysEnabled)
        	this.logger.log(Level.INFO, "You must now sync your iPod with your music management software " +
                                    "or delete 'Play Counts' from the iTunes folder!");
        
        //job done; clear cache & disable buttons to avoid abuse
        if(AudioPod.iTEnabled)
        	IScrobbler.clearCache();
        if(AudioPod.waEnabled)
        	WaScrobbler.clearCache();
		ui.disableCacheB();
		ui.disableSubmitB();
    }
    
    private String hexencode(byte[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append(Integer.toHexString((array[i] & 0xFF) | 0x100).substring(1,3));
        }
        return sb.toString();
    }
    
    public boolean submitSongs(HttpURLConnection c, String querystring) throws UnsupportedEncodingException, NoSuchAlgorithmException,
    										MalformedURLException, IOException, FailedLoginException{
    	c.connect();
        
        this.logger.log(Level.FINE, "POST query string:\n" + querystring);
        OutputStreamWriter wr = new OutputStreamWriter(c.getOutputStream());
        wr.write(querystring);
        wr.flush();
        
        if(c.getResponseCode() != 200) {
            throw new RuntimeException("Invalid HTTP return code");
        }
        
        BufferedReader breader = new BufferedReader(new InputStreamReader(c.getInputStream()));
        
        String content = null;
        String buffer = null;
        while ((buffer = breader.readLine()) != null) {
            if(content != null) {
                content += buffer + "\n";
            } else {
                content = buffer + "\n";
            }
        }
        this.logger.log(Level.FINE, "Received from server:\n" + content);
        
        if(content.length() == 0) {
            throw new RuntimeException("Invalid response received from AudioScrobbler");
        }
        
        String lines[] = content.split("\n");
        if(lines[0].length() >= 6 && lines[0].substring(0, 6).equals("FAILED")) {
            throw new RuntimeException(lines[0].substring(7));
        }
        if(lines[0].length() >= 7 && lines[0].substring(0, 7).equals("BADAUTH")) {
            throw new FailedLoginException("Invalid username/password");
        }
        if(lines[0].length() >= 2 && !lines[0].substring(0, 2).equals("OK")) {
            throw new RuntimeException("Unknown error submitting tracks");
        }
        return true;
    }
}